/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWParticipantsDialog;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWDesignerParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredParticipantDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWStepParticipantsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
IVWPropertyChangeListener,
IVWPropertyChangeSource,
IVWCoordinationEventListener {
    private static final int INITIALIZE = 1;
    private static final int ADDING_PARTICIPANTS = 2;
    private static final int SETTING_QUEUE = 3;
    protected VWStepDefinition m_stepDefinition = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    private String[] m_workQueueNames = null;
    private VWParticipantItem[] m_wflGroupList = null;
    private int m_nOperationType = 1;
    private Vector m_changedItems = null;
    private JRadioButton m_assignParticipantRButton = null;
    private JButton m_addParticipantButton = null;
    private JButton m_deleteParticipantButton = null;
    private VWSortedListModel m_participantListModel = null;
    private JList m_participantList = null;
    private JRadioButton m_assignWorkQueueRButton = null;
    private JComboBox m_assignWorkQueueComboBox = null;
    private IVWParticipantSelectionDialog m_vwParticipantsDialog = null;
    private JCheckBox m_ignoreMissingParticipantsCheckBox = null;
    private VWParticipant[] m_vwParticipantsCache = null;
    private JCheckBox m_reassignCheckBox = null;
    private JCheckBox m_viewStatusCheckBox = null;
    private JCheckBox m_viewHistoryCheckBox = null;

    public void actionPerformed(ActionEvent event) {
        try {
            Object src = event.getSource();
            if (src.equals(this.m_assignParticipantRButton)) {
                this.onAssignParticipantRButton();
            } else if (src.equals(this.m_addParticipantButton)) {
                this.onAddParticipantButton();
            } else if (src.equals(this.m_deleteParticipantButton)) {
                this.onDeleteParticipantButton();
            } else if (src.equals(this.m_assignWorkQueueRButton)) {
                this.onAssignWorkQueueRButton();
            } else if (src.equals(this.m_assignWorkQueueComboBox)) {
                this.onAssignWorkQueueComboBox();
            } else if (src.equals(this.m_reassignCheckBox)) {
                this.onReassignCheckBox();
            } else if (src.equals(this.m_viewStatusCheckBox)) {
                this.onViewStatusCheckBox();
            } else if (src.equals(this.m_viewHistoryCheckBox)) {
                this.onViewHistoryCheckBox();
            } else if (src.equals(this.m_ignoreMissingParticipantsCheckBox)) {
                this.onIgnoreMissingParticipants();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.m_participantList) {
            this.m_deleteParticipantButton.setEnabled(!this.m_participantListModel.isEmpty() && this.m_participantList.getSelectedIndex() != -1);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            switch (event.getID()) {
                case 558: 
                case 559: 
                case 560: {
                    this.updateGroupLists();
                    break;
                }
                case 561: {
                    IVWPropertyChangeSource source = (IVWPropertyChangeSource)event.getSource();
                    this.onRenameWorkflowGroup(source.getItemsChanged());
                    this.updateGroupLists();
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 757: 
            case 770: 
            case 771: 
            case 772: {
                this.m_workQueueNames = null;
                this.setSelectedStep(this.m_stepDefinition);
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setSelectedStep(VWMapNode vwMapNode) {
        this.m_stepDefinition = (VWStepDefinition)vwMapNode;
        this.m_nOperationType = 1;
        this.initWQueueComboBox();
        if (this.m_stepDefinition != null) {
            this.m_reassignCheckBox.setEnabled(true);
            this.m_reassignCheckBox.setSelected(this.m_stepDefinition.getCanReassign());
            this.m_viewStatusCheckBox.setEnabled(true);
            this.m_viewStatusCheckBox.setSelected(this.m_stepDefinition.getCanViewStatus());
            this.m_viewHistoryCheckBox.setEnabled(true);
            this.m_viewHistoryCheckBox.setSelected(this.m_stepDefinition.getCanViewHistory());
            this.m_nOperationType = this.m_stepDefinition.getQueueName() != null && !this.m_stepDefinition.getQueueName().equals("Inbox") ? 3 : 2;
            this.m_ignoreMissingParticipantsCheckBox.removeActionListener(this);
            this.m_ignoreMissingParticipantsCheckBox.setSelected(this.m_stepDefinition.getIgnoreInvalidUsers());
            this.m_ignoreMissingParticipantsCheckBox.addActionListener(this);
        } else {
            this.m_reassignCheckBox.setSelected(false);
            this.m_viewStatusCheckBox.setSelected(false);
            this.m_viewHistoryCheckBox.setSelected(false);
            this.m_ignoreMissingParticipantsCheckBox.setSelected(false);
        }
        this.m_vwParticipantsCache = null;
        this.initAssignmentControls();
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_addParticipantButton != null) {
            this.m_addParticipantButton.removeActionListener(this);
            this.m_addParticipantButton.removeAll();
            this.m_addParticipantButton = null;
        }
        if (this.m_assignWorkQueueComboBox != null) {
            this.m_assignWorkQueueComboBox.removeActionListener(this);
            this.m_assignWorkQueueComboBox.removeAllItems();
            this.m_assignWorkQueueComboBox = null;
        }
        this.m_workQueueNames = null;
        if (this.m_participantListModel != null) {
            this.m_participantListModel.removeAllElements();
            this.m_participantListModel = null;
        }
        if (this.m_participantList != null) {
            this.m_participantList.removeListSelectionListener(this);
            VWDesignerParticipantListCellRenderer cellRenderer = (VWDesignerParticipantListCellRenderer)this.m_participantList.getCellRenderer();
            cellRenderer.releaseReferences();
            cellRenderer = null;
            this.m_participantList.setCellRenderer(null);
            this.m_participantList = null;
        }
        if (this.m_reassignCheckBox != null) {
            this.m_reassignCheckBox.removeActionListener(this);
            this.m_reassignCheckBox = null;
        }
        if (this.m_viewStatusCheckBox != null) {
            this.m_viewStatusCheckBox.removeActionListener(this);
            this.m_viewStatusCheckBox = null;
        }
        if (this.m_viewHistoryCheckBox != null) {
            this.m_viewHistoryCheckBox.removeActionListener(this);
            this.m_viewHistoryCheckBox = null;
        }
        this.m_vwParticipantsCache = null;
        if (this.m_vwParticipantsDialog != null) {
            this.m_vwParticipantsDialog.releaseReferences();
            this.m_vwParticipantsDialog = null;
        }
        this.m_wflGroupList = null;
        this.m_authPropertyData = null;
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout());
            VWToolbarBorder tbBorder = new VWToolbarBorder(VWResource.s_activityType, 0x40000000);
            this.add((Component)tbBorder, "Center");
            JPanel clientPanel = tbBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            clientPanel.add((Component)this.getAssignmentPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            clientPanel.add((Component)this.getAllowParticipantsPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getAssignmentPanel() {
        try {
            JPanel clientPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 3, 15);
            ButtonGroup bGroup = new ButtonGroup();
            this.m_assignWorkQueueRButton = new JRadioButton(VWResource.s_stepAssignWorkQueue, false);
            this.m_assignWorkQueueRButton.addActionListener(this);
            this.m_assignWorkQueueRButton.setSelected(false);
            bGroup.add(this.m_assignWorkQueueRButton);
            clientPanel.add((Component)this.m_assignWorkQueueRButton, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_assignParticipantRButton = new JRadioButton(VWResource.s_stepAssignParticipant, false);
            this.m_assignParticipantRButton.addActionListener(this);
            this.m_assignParticipantRButton.setSelected(true);
            bGroup.add(this.m_assignParticipantRButton);
            clientPanel.add((Component)this.m_assignParticipantRButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_addParticipantButton = (JButton)VWImageLoader.createToolBarButton("update.gif", VWResource.s_modify, false);
            this.m_addParticipantButton.setName("m_addParticipantButton_VWGeneralStepGeneralTab");
            this.m_addParticipantButton.addActionListener(this);
            clientPanel.add((Component)this.m_addParticipantButton, gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 0, 0, 15);
            this.m_deleteParticipantButton = (JButton)VWImageLoader.createToolBarButton("delete.gif", VWResource.s_deleteStr, false);
            this.m_deleteParticipantButton.setName("m_deleteParticipantButton_VWGeneralStepGeneralTab");
            this.m_deleteParticipantButton.addActionListener(this);
            clientPanel.add((Component)this.m_deleteParticipantButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 0.1;
            gbCons.insets = new Insets(0, 10, 0, 15);
            this.m_assignWorkQueueComboBox = new JComboBox();
            this.m_assignWorkQueueComboBox.setName("m_assignWorkQueueComboBox_VWGeneralStepGeneralTab");
            this.m_assignWorkQueueComboBox.addActionListener(this);
            this.m_assignWorkQueueComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_assignWorkQueueComboBox.setEnabled(false);
            clientPanel.add((Component)this.m_assignWorkQueueComboBox, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.9;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 3;
            gbCons.insets = new Insets(0, 10, 0, 15);
            this.m_participantListModel = new VWSortedListModel();
            this.m_participantList = new JList(this.m_participantListModel);
            this.m_participantList.setName("m_participantList_VWGeneralStepGeneralTab");
            this.m_participantList.setCellRenderer(new VWDesignerParticipantListCellRenderer());
            this.m_participantList.addListSelectionListener(this);
            clientPanel.add((Component)new JScrollPane(this.m_participantList), gbCons);
            return clientPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getAllowParticipantsPanel() {
        try {
            JPanel clientPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(0, 10, 3, 30);
            clientPanel.add((Component)new JLabel(VWResource.s_participantPrivileges), gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 10, 3, 30);
            this.m_reassignCheckBox = new JCheckBox(VWResource.s_stepReassign, false);
            this.m_reassignCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_reassignCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_viewStatusCheckBox = new JCheckBox(VWResource.s_stepViewStatus, false);
            this.m_viewStatusCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_viewStatusCheckBox, gbCons);
            ++gbCons.gridy;
            this.m_viewHistoryCheckBox = new JCheckBox(VWResource.s_stepViewHistory, false);
            this.m_viewHistoryCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_viewHistoryCheckBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            clientPanel.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            this.m_ignoreMissingParticipantsCheckBox = new JCheckBox(VWResource.s_ignoreMissingParticipants);
            this.m_ignoreMissingParticipantsCheckBox.addActionListener(this);
            clientPanel.add((Component)this.m_ignoreMissingParticipantsCheckBox, gbCons);
            return clientPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWQueueComboBox() {
        try {
            this.m_assignWorkQueueComboBox.removeActionListener(this);
            DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel();
            if (this.m_workQueueNames == null) {
                this.m_workQueueNames = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueNames(2);
                if (this.m_workQueueNames != null && this.m_workQueueNames.length > 0) {
                    VWQuickSort sort = new VWQuickSort(this.m_workQueueNames, 0);
                    sort.sort(0, this.m_workQueueNames.length - 1);
                }
            }
            if (this.m_workQueueNames != null) {
                cbModel = new DefaultComboBoxModel<String>(this.m_workQueueNames);
            }
            this.m_assignWorkQueueComboBox.setModel(cbModel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_assignWorkQueueComboBox.addActionListener(this);
        }
    }

    private void initAssignmentControls() {
        this.m_assignParticipantRButton.setSelected(true);
        this.m_assignParticipantRButton.setEnabled(false);
        this.m_addParticipantButton.setEnabled(false);
        this.m_deleteParticipantButton.setEnabled(false);
        this.m_participantList.setEnabled(false);
        this.m_assignWorkQueueRButton.setSelected(false);
        this.m_assignWorkQueueRButton.setEnabled(false);
        this.m_assignWorkQueueComboBox.setEnabled(false);
        if (this.m_stepDefinition == null) {
            return;
        }
        switch (this.m_nOperationType) {
            case 1: {
                this.m_stepDefinition.setParticipants(null);
                this.m_stepDefinition.setQueueName(null);
                this.m_vwParticipantsCache = null;
                this.updateParticipantList();
                break;
            }
            case 2: {
                this.updateParticipantList();
                this.m_assignParticipantRButton.setSelected(true);
                this.m_assignParticipantRButton.setEnabled(true);
                this.m_ignoreMissingParticipantsCheckBox.setEnabled(true);
                this.m_addParticipantButton.setEnabled(true);
                this.m_deleteParticipantButton.setEnabled(!this.m_participantListModel.isEmpty() && this.m_participantList.getSelectedIndex() != -1);
                this.m_participantList.setEnabled(true);
                this.m_assignWorkQueueRButton.setSelected(false);
                if (this.m_assignWorkQueueComboBox.getItemCount() > 0 || this.m_stepDefinition.getQueueName() != null && VWStringUtils.compare(this.m_stepDefinition.getQueueName(), "Inbox") != 0) {
                    this.m_assignWorkQueueRButton.setEnabled(true);
                }
                this.m_assignWorkQueueComboBox.setEnabled(false);
                break;
            }
            case 3: {
                this.updateParticipantList();
                boolean bFound = false;
                int workQueueItemCount = this.m_assignWorkQueueComboBox.getItemCount();
                String queueName = this.m_stepDefinition.getQueueName();
                if (queueName != null) {
                    for (int index = 0; index < workQueueItemCount; ++index) {
                        if (VWStringUtils.compare(queueName, (String)this.m_assignWorkQueueComboBox.getItemAt(index)) != 0) continue;
                        bFound = true;
                        this.m_assignWorkQueueComboBox.removeActionListener(this);
                        this.m_assignWorkQueueComboBox.setSelectedIndex(index);
                        this.m_assignWorkQueueComboBox.addActionListener(this);
                        break;
                    }
                }
                if (!bFound) {
                    if (queueName != null) {
                        if (VWStringUtils.compare(queueName, "Inbox") != 0) {
                            this.m_assignWorkQueueComboBox.removeActionListener(this);
                            this.m_assignWorkQueueComboBox.addItem(queueName);
                            this.m_assignWorkQueueComboBox.setSelectedItem(queueName);
                            this.m_assignWorkQueueComboBox.addActionListener(this);
                        }
                    } else {
                        this.m_assignWorkQueueComboBox.removeActionListener(this);
                        if (this.m_assignWorkQueueComboBox.getItemCount() > 0) {
                            this.m_assignWorkQueueComboBox.setSelectedIndex(0);
                        }
                        this.m_assignWorkQueueComboBox.addActionListener(this);
                        if (this.m_assignWorkQueueComboBox.getSelectedItem() != null) {
                            this.m_stepDefinition.setQueueName((String)this.m_assignWorkQueueComboBox.getSelectedItem());
                        }
                    }
                }
                this.m_assignParticipantRButton.setSelected(false);
                this.m_assignParticipantRButton.setEnabled(true);
                this.m_ignoreMissingParticipantsCheckBox.setEnabled(false);
                this.m_addParticipantButton.setEnabled(false);
                this.m_deleteParticipantButton.setEnabled(false);
                this.m_participantList.setEnabled(false);
                boolean bHaveQueueDefs = this.m_assignWorkQueueComboBox.getItemCount() > 0;
                this.m_assignWorkQueueRButton.setSelected(bHaveQueueDefs);
                this.m_assignWorkQueueRButton.setEnabled(bHaveQueueDefs);
                this.m_assignWorkQueueComboBox.setEnabled(bHaveQueueDefs);
                break;
            }
        }
    }

    private void updateParticipantList() {
        VWParticipantItem[] vwParticipantItems = null;
        try {
            if (this.m_vwParticipantsCache != null) {
                vwParticipantItems = VWDefaultSessionProxy.getQuotedFullParticipantItems(this.m_vwParticipantsCache, true);
            } else {
                vwParticipantItems = VWDefaultSessionProxy.getQuotedFullParticipantItems(this.m_stepDefinition.getParticipants(), true);
                this.m_stepDefinition.setParticipants(VWDefaultSessionProxy.getParticipantsFromParticipantItems(vwParticipantItems, true));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_invalidStepParticipants, 1);
            }
            vwParticipantItems = this.m_vwParticipantsCache != null ? VWDefaultSessionProxy.getParticipantItemsUsingParticipants(this.m_vwParticipantsCache, true) : VWDefaultSessionProxy.getParticipantItemsUsingParticipants(this.m_stepDefinition.getParticipants(), true);
        }
        this.updateParticipantList(vwParticipantItems);
    }

    private void updateParticipantList(VWParticipantItem[] participantItems) {
        try {
            this.m_participantListModel.removeAllElements();
            if (this.m_stepDefinition.getParticipants() != null) {
                this.m_stepDefinition.setQueueName("Inbox");
            }
            if (participantItems != null && participantItems.length > 0) {
                for (int i = 0; i < participantItems.length; ++i) {
                    this.m_participantListModel.addElement(participantItems[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onRenameWorkflowGroup(Vector v) {
        try {
            if (v != null && v.size() >= 2) {
                int i;
                VWMapDefinition mapDefinition;
                String oldName = (String)v.elementAt(0);
                String newName = (String)v.elementAt(1);
                if (this.m_authPropertyData != null && (mapDefinition = this.m_authPropertyData.getMapDefinition("Workflow")) != null) {
                    VWMapNode[] mapNodes = mapDefinition.getSteps();
                    block2: for (i = 0; i < mapNodes.length; ++i) {
                        VWParticipant[] participants;
                        if (!(mapNodes[i] instanceof VWStepDefinition) || (participants = ((VWStepDefinition)mapNodes[i]).getParticipants()) == null) continue;
                        for (int j = 0; j < participants.length; ++j) {
                            String name = participants[j].getParticipantName();
                            if (!name.equals(oldName)) continue;
                            participants[j].setParticipantName(newName);
                            continue block2;
                        }
                    }
                }
                VWSortedListModel participantListModel = (VWSortedListModel)this.m_participantList.getModel();
                int len = participantListModel.getSize();
                for (i = 0; i < len; ++i) {
                    if (!participantListModel.getElementAt(i).equals(oldName)) continue;
                    participantListModel.setElementAt(newName, i);
                    break;
                }
                participantListModel.sort();
                this.m_participantList.setVisible(false);
                this.m_participantList.setVisible(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateGroupLists() {
        try {
            if (this.m_authPropertyData.getWorkflowDefinition() == null) {
                return;
            }
            Vector<String> fieldNames = new Vector<String>();
            VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
            if (fieldDefs != null) {
                for (int nIndex = 0; nIndex < fieldDefs.length; ++nIndex) {
                    if (fieldDefs[nIndex].getFieldType() != 64 || fieldDefs[nIndex].getName().equals("F_Trackers")) continue;
                    fieldNames.addElement(fieldDefs[nIndex].getName());
                }
            }
            fieldNames.addElement("F_Originator");
            if (fieldNames != null && fieldNames.size() > 0) {
                this.m_wflGroupList = new VWParticipantItem[fieldNames.size()];
                for (int i = 0; i < fieldNames.size(); ++i) {
                    this.m_wflGroupList[i] = new VWParticipantItem((String)fieldNames.elementAt(i), 2);
                }
            } else {
                this.m_wflGroupList = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAssignParticipantRButton() {
        try {
            if (this.m_nOperationType == 2) {
                return;
            }
            if (this.m_vwParticipantsCache != null) {
                this.m_stepDefinition.setParticipants(this.m_vwParticipantsCache);
                this.m_vwParticipantsCache = null;
            }
            this.m_stepDefinition.setQueueName(null);
            this.m_stepDefinition.setOperationName(null);
            this.m_stepDefinition.setOperationParameters(null);
            this.m_authPropertyData.setDirty();
            this.m_participantList.setEnabled(true);
            this.m_ignoreMissingParticipantsCheckBox.setEnabled(true);
            this.m_assignWorkQueueComboBox.setEnabled(false);
            this.m_nOperationType = 2;
            this.initAssignmentControls();
            this.m_changedItems = new Vector();
            this.m_changedItems.addElement(this.m_stepDefinition);
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAddParticipantButton() {
        try {
            VWSession vwSession = this.m_authPropertyData.getVWSession();
            if (vwSession != null) {
                if (this.m_vwParticipantsDialog == null) {
                    this.m_vwParticipantsDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredParticipantDialog(this.m_authPropertyData.getMainContainer(), vwSession, this.m_authPropertyData.getShowParticipants()) : new VWParticipantsDialog(this.m_authPropertyData.getMainContainer(), vwSession, this.m_authPropertyData.getShowParticipants());
                }
                if (this.m_wflGroupList == null) {
                    this.updateGroupLists();
                }
                Object[] objects = this.m_participantListModel.toArray();
                VWParticipantItem[] items = null;
                if (objects != null && objects.length > 0) {
                    items = new VWParticipantItem[objects.length];
                    System.arraycopy(objects, 0, items, 0, objects.length);
                }
                this.m_vwParticipantsDialog.init(items, this.m_wflGroupList);
                this.m_vwParticipantsDialog.setVisible(true);
                if (this.m_vwParticipantsDialog.getStatus() == 1) {
                    VWParticipantItem[] participantItems = this.m_vwParticipantsDialog.getParticipants();
                    if (participantItems != null && participantItems.length > 0) {
                        this.m_stepDefinition.setParticipants(VWDefaultSessionProxy.getParticipantsFromParticipantItems(participantItems, true));
                    } else {
                        this.m_stepDefinition.setParticipants(null);
                    }
                    this.updateParticipantList(participantItems);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(this.m_stepDefinition);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void onDeleteParticipantButton() {
        try {
            int[] selectedIndices = this.m_participantList.getSelectedIndices();
            if (selectedIndices != null && this.m_stepDefinition != null) {
                int nTotalSelectedCount = selectedIndices.length;
                int nParticipantListSize = this.m_participantListModel.getSize();
                for (int nIndex = nParticipantListSize - 1; nIndex >= 0; --nIndex) {
                    for (int selectedIndex = 0; selectedIndex < selectedIndices.length; ++selectedIndex) {
                        if (nIndex != selectedIndices[selectedIndex]) continue;
                        this.m_participantListModel.removeElementAt(selectedIndices[selectedIndex]);
                        if (--nTotalSelectedCount == 0) break;
                    }
                    if (nTotalSelectedCount == 0) break;
                }
                if (this.m_participantListModel.getSize() == 0) {
                    this.m_stepDefinition.setQueueName(null);
                    this.m_stepDefinition.setParticipants(null);
                    this.m_deleteParticipantButton.setEnabled(true);
                    this.m_addParticipantButton.setEnabled(true);
                } else {
                    Object[] listObjects = this.m_participantListModel.toArray();
                    if (listObjects != null && listObjects.length > 0) {
                        VWParticipantItem[] vwParticipantItems = new VWParticipantItem[listObjects.length];
                        System.arraycopy(listObjects, 0, vwParticipantItems, 0, listObjects.length);
                        this.m_stepDefinition.setParticipants(VWDefaultSessionProxy.getParticipantsFromParticipantItems(vwParticipantItems, true));
                    }
                }
                this.m_deleteParticipantButton.setEnabled(!this.m_participantListModel.isEmpty() && this.m_participantList.getSelectedIndex() != -1);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAssignWorkQueueRButton() {
        try {
            if (this.m_nOperationType == 3) {
                return;
            }
            this.m_vwParticipantsCache = this.m_stepDefinition.getParticipants();
            this.m_stepDefinition.setParticipants(null);
            this.m_stepDefinition.setQueueName(null);
            this.m_stepDefinition.setOperationName(null);
            this.m_stepDefinition.setOperationParameters(null);
            this.initWQueueComboBox();
            this.m_participantList.setEnabled(false);
            this.m_ignoreMissingParticipantsCheckBox.setEnabled(false);
            this.m_assignWorkQueueComboBox.setEnabled(this.m_assignWorkQueueComboBox.getItemCount() > 0);
            this.m_nOperationType = 3;
            this.initAssignmentControls();
            this.m_authPropertyData.setDirty();
            this.m_changedItems = new Vector();
            this.m_changedItems.addElement(this.m_stepDefinition);
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 531);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAssignWorkQueueComboBox() {
        try {
            if (!this.m_assignWorkQueueRButton.isSelected() || this.m_workQueueNames == null || this.m_stepDefinition == null) {
                return;
            }
            String name = (String)this.m_assignWorkQueueComboBox.getSelectedItem();
            if (name != null && VWStringUtils.compare(name, this.m_stepDefinition.getQueueName()) != 0) {
                this.m_stepDefinition.setQueueName(name);
                this.m_stepDefinition.setOperationName(null);
                this.m_stepDefinition.setOperationParameters(null);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 531);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onReassignCheckBox() {
        try {
            if (this.m_stepDefinition != null) {
                this.m_stepDefinition.setCanReassign(this.m_reassignCheckBox.isSelected());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onViewStatusCheckBox() {
        try {
            if (this.m_stepDefinition != null) {
                this.m_stepDefinition.setCanViewStatus(this.m_viewStatusCheckBox.isSelected());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onIgnoreMissingParticipants() {
        try {
            if (this.m_stepDefinition != null) {
                this.m_stepDefinition.setIgnoreInvalidUsers(this.m_ignoreMissingParticipantsCheckBox.isSelected());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onViewHistoryCheckBox() {
        try {
            if (this.m_stepDefinition != null) {
                this.m_stepDefinition.setCanViewHistory(this.m_viewHistoryCheckBox.isSelected());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

